<?php
/* --------------------------------------------------------------
   ParcelServiceSortings.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\SqlCriteria;

use ArrayIterator;
use Gambio\Core\Criteria\SqlSortings;
use Traversable;

/**
 * Class ParcelServiceSortings
 *
 * @package Gambio\Admin\ParcelService\SqlCriteria
 */
class ParcelServiceSortings implements SqlSortings
{
    /**
     * @var ParcelServiceSorting[]
     */
    private $sortings;
    
    
    /**
     * ParcelServiceSortings constructor.
     *
     * @param ParcelServiceSorting ...$sortings
     */
    private function __construct(ParcelServiceSorting ...$sortings)
    {
        $this->sortings = $sortings;
    }
    
    
    /**
     * @param ParcelServiceSorting ...$sortings
     *
     * @return ParcelServiceSortings
     */
    public static function create(ParcelServiceSorting ...$sortings): ParcelServiceSortings
    {
        return new self(...$sortings);
    }
    
    
    /**
     * @param ParcelServiceSorting ...$sortings
     *
     * @return $this
     */
    public function add(ParcelServiceSorting ...$sortings): self
    {
        $this->sortings = array_merge($this->sortings, $sortings);
        
        return $this;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->sortings);
    }
}